/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.definition;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class DungeonPlacer {
    public static DungeonPlacer createFromJson(JsonObject json) {
        String type = json.get("type").getAsString();
        DungeonPlacer spawnCondition = null;
        if ("random".equalsIgnoreCase(type)) {
            spawnCondition = new RandomPlacer();
        } else if ("surface".equalsIgnoreCase(type)) {
            spawnCondition = new SurfacePlacer();
        }
        ((DungeonPlacer)spawnCondition).loadFromJSON(json);
        return spawnCondition;
    }

    public void loadFromJSON(JsonObject json) {
    }

    public abstract BlockPos calculatePosition(World var1, BlockPos var2, Random var3);

    public static class SurfacePlacer
    extends DungeonPlacer {
        private Set<Material> materialsToIgnore = Stream.of(Material.field_151579_a, Material.field_151575_d, Material.field_151584_j, Material.field_151585_k, Material.field_151582_l, Material.field_151597_y, Material.field_151570_A).collect(Collectors.toSet());

        @Override
        public void loadFromJSON(JsonObject json) {
            this.materialsToIgnore = new HashSet<Material>(JSONHelper.getJsonMaterials(json));
        }

        @Override
        public BlockPos calculatePosition(World world, BlockPos pos, Random random) {
            Chunk chunk = world.func_175726_f(pos);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.func_177958_n(), chunk.func_76625_h() + 15, pos.func_177952_p());
            Material material = chunk.func_177435_g((BlockPos)mutablePos).func_185904_a();
            while (mutablePos.func_177956_o() > 0 && this.materialsToIgnore.contains(material)) {
                mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                material = chunk.func_177435_g((BlockPos)mutablePos).func_185904_a();
            }
            return new BlockPos(pos.func_177958_n(), mutablePos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static class RandomPlacer
    extends DungeonPlacer {
        private int minY = 64;
        private int maxY = 64;

        @Override
        public void loadFromJSON(JsonObject json) {
            if (json.has("minY")) {
                this.minY = json.get("minY").getAsInt();
            }
            if (json.has("maxY")) {
                this.maxY = json.get("maxY").getAsInt();
            }
        }

        @Override
        public BlockPos calculatePosition(World world, BlockPos pos, Random random) {
            int y = this.minY;
            if (this.minY < this.maxY) {
                y += random.nextInt(this.maxY - this.minY);
            }
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }
    }
}

